<!-- Swiper CSS -->
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/swiper@8/swiper-bundle.min.css" />

<section class="vencedores-section" id="vencedores">
    <div class="container">
        <div class="vencedores-header text-center">
            <p class="subtitulo">Conheça as marcas mais lembradas da educação</p>
            <h2 class="titulo-principal">Vencedores 2024</h2>
        </div>

        <div class="vencedores-wrapper">
            <!-- Menu lateral -->
            <div class="vencedores-anos">
                <ul id="anos-lista">
                    <li><a href="/vencedores/vencedores.php">2025</a></li>
                    <li class="ativo"><a href="/vencedores/vencedores-2024.html.php">2024</a></li>
                    <li><a href="/vencedores/vencedores-2023.html.php">2023</a></li>
                    <li><a href="/vencedores/vencedores-2022.html.php">2022</a></li>
                    <li><a href="/vencedores/vencedores-2021.html.php">2021</a></li>
                </ul>
            </div>

            <!-- Carrossel de 2024 -->
            <div class="swiper vencedores-carousel">
                <div class="swiper-wrapper">
                    <div class="swiper-slide">
                        <div class="vencedor-card">
                            <span class="categoria">Categoria 2024</span>
                            <img src="<?php echo get_template_directory_uri(); ?>/img/NR.png" alt="Marca 2024">
                        </div>
                    </div>
                    <!-- Outros slides de 2024 -->
                </div>

                <div class="swiper-button-prev swiper-button-prev-vencedores"></div>
                <div class="swiper-button-next swiper-button-next-vencedores"></div>
            </div>
        </div>
    </div>
</section>

<!-- Swiper JS -->
<script src="https://cdn.jsdelivr.net/npm/swiper@8/swiper-bundle.min.js"></script>
<script>
    document.addEventListener("DOMContentLoaded", function () {
        new Swiper(".vencedores-carousel", {
            slidesPerView: 3,
            spaceBetween: 30,
            navigation: {
                nextEl: ".swiper-button-next-vencedores",
                prevEl: ".swiper-button-prev-vencedores"
            },
            autoplay: {
                delay: 3000,
                disableOnInteraction: false
            },
            breakpoints: {
                0: { slidesPerView: 1 },
                768: { slidesPerView: 2 },
                1024: { slidesPerView: 3 }
            }
        });
    });
</script>
