
<section class="vencedores-section" id="vencedores">
    <div class="container">
        <div class="vencedores-header text-center">
            <p class="subtitulo">Conheça as marcas mais lembradas da educação</p>
            <h2 class="titulo-principal">Vencedores</h2>
        </div>

        <div class="vencedores-wrapper">
            <!-- Coluna de anos -->
            <div class="vencedores-anos">
                <ul id="anos-lista">
                    <li class="ativo" data-ano="2024">2024</li>
                    <li data-ano="2023">2023</li>
                    <li data-ano="2022">2022</li>
                    <li data-ano="2021">2021</li>
                    <li data-ano="2020">2020</li>
                </ul>
            </div>

            <!-- Carrossel 2024 -->
            <div class="swiper vencedores-carousel" data-ano="2024" style="display: block;">
                <div class="swiper-wrapper">
                    <div class="swiper-slide">
                        <div class="vencedor-card">
                            <span class="categoria">Acampamentos</span>
                            <img src="<?php echo get_template_directory_uri(); ?>/img/NR.png" alt="Imagem 01">
                        </div>
                    </div>
                    <div class="swiper-slide">
                        <div class="vencedor-card">
                            <span class="categoria">Ação Social</span>
                            <img src="<?php echo get_template_directory_uri(); ?>/img/FTD Educacao.png" alt="Imagem 02">
                        </div>
                    </div>
                    <div class="swiper-slide">
                        <div class="vencedor-card">
                            <span class="categoria">Brinquedos Educativos</span>
                            <img src="<?php echo get_template_directory_uri(); ?>/img/Pimpao.png" alt="Imagem 03">
                        </div>
                    </div>
                    <div class="swiper-slide">
                        <div class="vencedor-card">
                            <span class="categoria">Consultoria Educacional</span>
                            <img src="<?php echo get_template_directory_uri(); ?>/img/COC.png" alt="Imagem 04">
                        </div>
                    </div>
                    <div class="swiper-slide">
                        <div class="vencedor-card">
                            <span class="categoria">Editora de Livros Didáticos</span>
                            <img src="<?php echo get_template_directory_uri(); ?>/img/EditoradoBrasil.png" alt="Imagem 03">
                        </div>
                    </div>
                    <div class="swiper-slide">
                        <div class="vencedor-card">
                            <span class="categoria">Editora de Livros Didáticos de Idiomas</span>
                            <img src="<?php echo get_template_directory_uri(); ?>/img/StandFor.png" alt="Imagem 03">
                        </div>
                    </div>
                    <div class="swiper-slide">
                        <div class="vencedor-card">
                            <span class="categoria">Educação financeira</span>
                            <img src="<?php echo get_template_directory_uri(); ?>/img/JovensForSchool.png" alt="Imagem 03">
                        </div>
                    </div>
                    <div class="swiper-slide">
                        <div class="vencedor-card">
                            <span class="categoria">Fabricante de computadores /tablets e notebooks</span>
                            <img src="<?php echo get_template_directory_uri(); ?>/img/Lenovo.png" alt="Imagem 03">
                        </div>
                    </div>
                    <div class="swiper-slide">
                        <div class="vencedor-card">
                            <span class="categoria">Gestão financeira</span>
                            <img src="<?php echo get_template_directory_uri(); ?>/img/Isaac.png" alt="Imagem 03">
                        </div>
                    </div>
                    <div class="swiper-slide">
                        <div class="vencedor-card">
                            <span class="categoria">Instituição de Ensino para formação de docentes</span>
                            <img src="<?php echo get_template_directory_uri(); ?>/img/Uninter.png" alt="Imagem 03">
                        </div>
                    </div>
                    <div class="swiper-slide">
                        <div class="vencedor-card">
                            <span class="categoria">Literatura Infantojuvenil</span>
                            <img src="<?php echo get_template_directory_uri(); ?>/img/Moderna.png" alt="Imagem 03">
                        </div>
                    </div>
                    <div class="swiper-slide">
                        <div class="vencedor-card">
                            <span class="categoria">Programa avançado de inglês para escolas</span>
                            <img src="<?php echo get_template_directory_uri(); ?>/img/CNA.png" alt="Imagem 03">
                        </div>
                    </div>
                    <div class="swiper-slide">
                        <div class="vencedor-card">
                            <span class="categoria">Programa de educação socioemocional</span>
                            <img src="<?php echo get_template_directory_uri(); ?>/img/EI-EscoladeInteligencia.png" alt="Imagem 03">
                        </div>
                    </div>
                    <div class="swiper-slide">
                        <div class="vencedor-card">
                            <span class="categoria">Projetos educacionais</span>
                            <img src="<?php echo get_template_directory_uri(); ?>/img/FaberCastellEdux.png" alt="Imagem 03">
                        </div>
                    </div>
                    <div class="swiper-slide">
                        <div class="vencedor-card">
                            <span class="categoria">Facilities(cantinas escolares, segurança e terceirização)</span>
                            <img src="<?php echo get_template_directory_uri(); ?>/img/Sodexo.png" alt="Imagem 03">
                        </div>
                    </div>
                    <div class="swiper-slide">
                        <div class="vencedor-card">
                            <span class="categoria">Seguro educacional</span>
                            <img src="<?php echo get_template_directory_uri(); ?>/img/Bradesco.png" alt="Imagem 03">
                        </div>
                    </div>
                    <div class="swiper-slide">
                        <div class="vencedor-card">
                            <span class="categoria">Sistema de Ensino Bilíngue</span>
                            <img src="<?php echo get_template_directory_uri(); ?>/img/InternationalSchool.png" alt="Imagem 03">
                        </div>
                    </div>
                    <div class="swiper-slide">
                        <div class="vencedor-card">
                            <span class="categoria">Sistema de Ensino Rede Privada</span>
                            <img src="<?php echo get_template_directory_uri(); ?>/img/FTDSistemadeEnsino.png" alt="Imagem 03">
                        </div>
                    </div>
                    <div class="swiper-slide">
                        <div class="vencedor-card">
                            <span class="categoria">Sistema de Ensino Rede Pública</span>
                            <img src="<?php echo get_template_directory_uri(); ?>/img/AprendeBrasil.png" alt="Imagem 03">
                        </div>
                    </div>
                    <div class="swiper-slide">
                        <div class="vencedor-card">
                            <span class="categoria">Softwares Administrativos / Gestão / Horários</span>
                            <img src="<?php echo get_template_directory_uri(); ?>/img/Sponte.png" alt="Imagem 03">
                        </div>
                    </div>
                    <div class="swiper-slide">
                        <div class="vencedor-card">
                            <span class="categoria">Softwares Educacionais</span>
                            <img src="<?php echo get_template_directory_uri(); ?>/img/Arvore.png" alt="Imagem 03">
                        </div>
                    </div>
                    <div class="swiper-slide">
                        <div class="vencedor-card">
                            <span class="categoria">Tecnologia Audiovisual</span>
                            <img src="<?php echo get_template_directory_uri(); ?>/img/Epson.png" alt="Imagem 03">
                        </div>
                    </div>
                    <div class="swiper-slide">
                        <div class="vencedor-card">
                            <span class="categoria">Turismo Educacional</span>
                            <img src="<?php echo get_template_directory_uri(); ?>/img/CIintercambio.png" alt="Imagem 03">
                        </div>
                    </div>

                </div>
                <div class="swiper-button-prev swiper-button-prev-vencedores"></div>
                <div class="swiper-button-next swiper-button-next-vencedores"></div>
            </div>


            <!-- Carrossel 2023 -->
            <div class="swiper vencedores-carousel" data-ano="2023" style="display: none;">
                <div class="swiper-wrapper">
                    <div class="swiper-slide">
                        <div class="vencedor-card">
                            <span class="categoria">Acampamentos</span>
                            <img src="<?php echo get_template_directory_uri(); ?>/img/logosomoseducacao.png" alt="Imagem 01">
                        </div>
                    </div>
                    <div class="swiper-slide">
                        <div class="vencedor-card">
                            <span class="categoria">Ação Social</span>
                            <img src="<?php echo get_template_directory_uri(); ?>/img/Pimpao.png" alt="Imagem 02">
                        </div>
                    </div>
                    <div class="swiper-slide">
                        <div class="vencedor-card">
                            <span class="categoria">Brinquedos Educativos</span>
                            <img src="<?php echo get_template_directory_uri(); ?>/img/logosomoseducacao.png" alt="Imagem 03">
                        </div>
                    </div>
                    <div class="swiper-slide">
                        <div class="vencedor-card">
                            <span class="categoria">Consultoria Educacional</span>
                            <img src="<?php echo get_template_directory_uri(); ?>/img/logosomoseducacao.png" alt="Imagem 04">
                        </div>
                    </div>
                    <div class="swiper-slide">
                        <div class="vencedor-card">
                            <span class="categoria">Editora de Livros Didáticos</span>
                            <img src="<?php echo get_template_directory_uri(); ?>/img/EditoradoBrasil.png" alt="Imagem 03">
                        </div>
                    </div>
                    <div class="swiper-slide">
                        <div class="vencedor-card">
                            <span class="categoria">Editora de Livros Didáticos de Idiomas</span>
                            <img src="<?php echo get_template_directory_uri(); ?>/img/StandFor.png" alt="Imagem 03">
                        </div>
                    </div>
                    <div class="swiper-slide">
                        <div class="vencedor-card">
                            <span class="categoria">Educação financeira</span>
                            <img src="<?php echo get_template_directory_uri(); ?>/img/JovensForSchool.png" alt="Imagem 03">
                        </div>
                    </div>
                    <div class="swiper-slide">
                        <div class="vencedor-card">
                            <span class="categoria">Fabricante de computadores /tablets e notebooks</span>
                            <img src="<?php echo get_template_directory_uri(); ?>/img/Lenovo.png" alt="Imagem 03">
                        </div>
                    </div>
                    <div class="swiper-slide">
                        <div class="vencedor-card">
                            <span class="categoria">Gestão financeira</span>
                            <img src="<?php echo get_template_directory_uri(); ?>/img/Isaac.png" alt="Imagem 03">
                        </div>
                    </div>
                    <div class="swiper-slide">
                        <div class="vencedor-card">
                            <span class="categoria">Instituição de Ensino para formação de docentes</span>
                            <img src="<?php echo get_template_directory_uri(); ?>/img/Uninter.png" alt="Imagem 03">
                        </div>
                    </div>
                    <div class="swiper-slide">
                        <div class="vencedor-card">
                            <span class="categoria">Literatura Infantojuvenil</span>
                            <img src="<?php echo get_template_directory_uri(); ?>/img/Moderna.png" alt="Imagem 03">
                        </div>
                    </div>
                    <div class="swiper-slide">
                        <div class="vencedor-card">
                            <span class="categoria">Programa avançado de inglês para escolas</span>
                            <img src="<?php echo get_template_directory_uri(); ?>/img/CNA.png" alt="Imagem 03">
                        </div>
                    </div>
                    <div class="swiper-slide">
                        <div class="vencedor-card">
                            <span class="categoria">Programa de educação socioemocional</span>
                            <img src="<?php echo get_template_directory_uri(); ?>/img/EI-EscoladeInteligencia.png" alt="Imagem 03">
                        </div>
                    </div>
                    <div class="swiper-slide">
                        <div class="vencedor-card">
                            <span class="categoria">Projetos educacionais</span>
                            <img src="<?php echo get_template_directory_uri(); ?>/img/FaberCastellEdux.png" alt="Imagem 03">
                        </div>
                    </div>
                    <div class="swiper-slide">
                        <div class="vencedor-card">
                            <span class="categoria">Facilities(cantinas escolares, segurança e terceirização)</span>
                            <img src="<?php echo get_template_directory_uri(); ?>/img/Sodexo.png" alt="Imagem 03">
                        </div>
                    </div>
                    <div class="swiper-slide">
                        <div class="vencedor-card">
                            <span class="categoria">Seguro educacional</span>
                            <img src="<?php echo get_template_directory_uri(); ?>/img/Bradesco.png" alt="Imagem 03">
                        </div>
                    </div>
                    <div class="swiper-slide">
                        <div class="vencedor-card">
                            <span class="categoria">Sistema de Ensino Bilíngue</span>
                            <img src="<?php echo get_template_directory_uri(); ?>/img/InternationalSchool.png" alt="Imagem 03">
                        </div>
                    </div>
                    <div class="swiper-slide">
                        <div class="vencedor-card">
                            <span class="categoria">Sistema de Ensino Rede Privada</span>
                            <img src="<?php echo get_template_directory_uri(); ?>/img/FTDSistemadeEnsino.png" alt="Imagem 03">
                        </div>
                    </div>
                    <div class="swiper-slide">
                        <div class="vencedor-card">
                            <span class="categoria">Sistema de Ensino Rede Pública</span>
                            <img src="<?php echo get_template_directory_uri(); ?>/img/AprendeBrasil.png" alt="Imagem 03">
                        </div>
                    </div>
                    <div class="swiper-slide">
                        <div class="vencedor-card">
                            <span class="categoria">Softwares Administrativos / Gestão / Horários</span>
                            <img src="<?php echo get_template_directory_uri(); ?>/img/Sponte.png" alt="Imagem 03">
                        </div>
                    </div>
                    <div class="swiper-slide">
                        <div class="vencedor-card">
                            <span class="categoria">Softwares Educacionais</span>
                            <img src="<?php echo get_template_directory_uri(); ?>/img/Arvore.png" alt="Imagem 03">
                        </div>
                    </div>
                    <div class="swiper-slide">
                        <div class="vencedor-card">
                            <span class="categoria">Tecnologia Audiovisual</span>
                            <img src="<?php echo get_template_directory_uri(); ?>/img/Epson.png" alt="Imagem 03">
                        </div>
                    </div>
                    <div class="swiper-slide">
                        <div class="vencedor-card">
                            <span class="categoria">Turismo Educacional</span>
                            <img src="<?php echo get_template_directory_uri(); ?>/img/CIintercambio.png" alt="Imagem 03">
                        </div>
                    </div>

                </div>
                <div class="swiper-button-prev swiper-button-prev-vencedores"></div>
                <div class="swiper-button-next swiper-button-next-vencedores"></div>
            </div>


            <!-- Carrossel  -->
            <div class="swiper vencedores-carousel" data-ano="2023" style="display: none;">
                <div class="swiper-wrapper">
                    <div class="swiper-slide">
                        <div class="vencedor-card">
                            <span class="categoria">Cursos</span>
                            <img src="<?php echo get_template_directory_uri(); ?>/img/01.png" alt="Imagem 01">
                        </div>
                    </div>
                    <div class="swiper-slide">
                        <div class="vencedor-card">
                            <span class="categoria">Tecnologia</span>
                            <img src="<?php echo get_template_directory_uri(); ?>/img/02.png" alt="Imagem 02">
                        </div>
                    </div>
                    <div class="swiper-slide">
                        <div class="vencedor-card">
                            <span class="categoria">Educação Infantil</span>
                            <img src="<?php echo get_template_directory_uri(); ?>/img/01.png" alt="Imagem 03">
                        </div>
                    </div>
                </div>
                <div class="swiper-button-prev swiper-button-prev-vencedores"></div>
                <div class="swiper-button-next swiper-button-next-vencedores"></div>
            </div>

            <!-- Carrossel 2022 -->
            <div class="swiper vencedores-carousel" data-ano="2022" style="display: none;">
                <div class="swiper-wrapper">
                    <div class="swiper-slide">
                        <div class="vencedor-card">
                            <span class="categoria">Educação Técnica</span>
                            <img src="<?php echo get_template_directory_uri(); ?>/img/02.png" alt="Imagem 01">
                        </div>
                    </div>
                    <div class="swiper-slide">
                        <div class="vencedor-card">
                            <span class="categoria">Editoras</span>
                            <img src="<?php echo get_template_directory_uri(); ?>/img/01.png" alt="Imagem 02">
                        </div>
                    </div>
                    <div class="swiper-slide">
                        <div class="vencedor-card">
                            <span class="categoria">Editoras</span>
                            <img src="<?php echo get_template_directory_uri(); ?>/img/01.png" alt="Imagem 02">
                        </div>
                    </div>
                </div>
                <div class="swiper-button-prev swiper-button-prev-vencedores"></div>
                <div class="swiper-button-next swiper-button-next-vencedores"></div>
            </div>

            <!-- Carrossel 2021 -->
            <div class="swiper vencedores-carousel" data-ano="2021" style="display: none;">
                <div class="swiper-wrapper">
                    <div class="swiper-slide">
                        <div class="vencedor-card">
                            <span class="categoria">Educação Técnica</span>
                            <img src="<?php echo get_template_directory_uri(); ?>/img/02.png" alt="Imagem 01">
                        </div>
                    </div>
                    <div class="swiper-slide">
                        <div class="vencedor-card">
                            <span class="categoria">Editoras</span>
                            <img src="<?php echo get_template_directory_uri(); ?>/img/01.png" alt="Imagem 02">
                        </div>
                    </div>
                    <div class="swiper-slide">
                        <div class="vencedor-card">
                            <span class="categoria">Editoras</span>
                            <img src="<?php echo get_template_directory_uri(); ?>/img/01.png" alt="Imagem 02">
                        </div>
                    </div>
                    <div class="swiper-slide">
                        <div class="vencedor-card">
                            <span class="categoria">Editoras</span>
                            <img src="<?php echo get_template_directory_uri(); ?>/img/01.png" alt="Imagem 02">
                        </div>
                    </div>
                </div>
                <div class="swiper-button-prev swiper-button-prev-vencedores"></div>
                <div class="swiper-button-next swiper-button-next-vencedores"></div>
            </div>

            <!-- Carrossel 2020 -->
            <div class="swiper vencedores-carousel" data-ano="2020" style="display: none;">
                <div class="swiper-wrapper">
                    <div class="swiper-slide">
                        <div class="vencedor-card">
                            <span class="categoria">Educação Técnica</span>
                            <img src="<?php echo get_template_directory_uri(); ?>/img/02.png" alt="Imagem 01">
                        </div>
                    </div>
                    <div class="swiper-slide">
                        <div class="vencedor-card">
                            <span class="categoria">Editoras</span>
                            <img src="<?php echo get_template_directory_uri(); ?>/img/01.png" alt="Imagem 02">
                        </div>
                    </div>
                    <div class="swiper-slide">
                        <div class="vencedor-card">
                            <span class="categoria">Faculdades</span>
                            <img src="<?php echo get_template_directory_uri(); ?>/img/02.png" alt="Imagem 03">
                        </div>
                    </div>
                    <div class="swiper-slide">
                        <div class="vencedor-card">
                            <span class="categoria">Escolas Particulares</span>
                            <img src="<?php echo get_template_directory_uri(); ?>/img/01.png" alt="Imagem 04">
                        </div>
                    </div>
                    <div class="swiper-slide">
                        <div class="vencedor-card">
                            <span class="categoria">Plataformas Digitais</span>
                            <img src="<?php echo get_template_directory_uri(); ?>/img/02.png" alt="Imagem 05">
                        </div>
                    </div>
                </div>
                <div class="swiper-button-prev swiper-button-prev-vencedores"></div>
                <div class="swiper-button-next swiper-button-next-vencedores"></div>
            </div>
        </div>
    </div>
</section>
<script>
    document.addEventListener("DOMContentLoaded", function () {
        const swipers = {};

        document.querySelectorAll(".vencedores-carousel").forEach((carousel) => {
            const ano = carousel.dataset.ano;

            swipers[ano] = new Swiper(carousel, {
                slidesPerView: 3,
                spaceBetween: 30,
                navigation: {
                    nextEl: carousel.querySelector(".swiper-button-next-vencedores"),
                    prevEl: carousel.querySelector(".swiper-button-prev-vencedores")
                },
                autoplay: {
                    delay: 3000, // muda de slide a cada 3 segundos
                    disableOnInteraction: false
                },
                breakpoints: {
                    0: {
                        slidesPerView: 1
                    },
                    768: {
                        slidesPerView: 1
                    },
                    1024: {
                        slidesPerView: 3
                    }
                }
            });
        });

        document.querySelectorAll("#anos-lista li").forEach((item) => {
            item.addEventListener("click", () => {
                const ano = item.dataset.ano;

                document.querySelectorAll("#anos-lista li").forEach((el) => el.classList.remove("ativo"));
                item.classList.add("ativo");

                document.querySelectorAll(".vencedores-carousel").forEach((el) => {
                    el.style.display = el.dataset.ano === ano ? "block" : "none";
                });

                if (swipers[ano]) {
                    swipers[ano].update();
                }
            });
        });
    });
</script>
