<section id="regulamento" class="regulamento-aba-section">
    <div class="container text-center">
        <p class="subtitulo">Prêmio Top Educação 2025</p>
        <h2 class="titulo-principal">Regulamento</h2>

        <!-- Navegação -->
        <div class="abas-nav">
            <button class="aba-btn active" data-tab="sobre">Sobre o prêmio</button>
            <button class="aba-btn" data-tab="inscricao">Inscrição/votação</button>
            <button class="aba-btn" data-tab="categorias">Categorias</button>
            <button class="aba-btn" data-tab="apuracao">Apuração e resultados</button>
            <button class="aba-btn" data-tab="premiacao">Cerimônia de Premiação</button>
        </div>

        <div class="regulamento-wrapper">
            <!-- Conteúdo -->
            <div class="abas-conteudo">
                <div class="aba-item active" id="sobre">
                    <div class="aba-bloco">
                        <div class="icone">🏅</div>
                        <div class="texto text-start">
                            <p><strong>Art. 1º</strong> – Para identificar as marcas mais lembradas nas áreas da educação em 2025, <strong>realizamos</strong> pelo 19º ano consecutivo o <strong>Prêmio Top Educação – Educação Básica</strong>. O Top Educação é um prêmio concedido às empresas detentoras das <strong>marcas mais lembradas</strong> no setor de <strong>produtos e serviços</strong> do mercado educacional brasileiro.</p>

                            <p><strong>Art. 2º</strong> – Realização <strong>Revista Educação</strong> – São Paulo – SP, Brasil.</p>

                            <p><strong>Art. 3º</strong> – O Top Educação é um prêmio de <strong>“recall de marca”</strong>, tendo como metodologia <strong>pesquisa quantitativa de participação espontânea</strong> de internautas. Seu objetivo é apontar as marcas mais lembradas pelo público entre as empresas que atuam na área de educação. Assim, o Prêmio Top Educação é concedido <strong>às empresas detentoras das marcas mais lembradas</strong> no setor de <strong>produtos e serviços</strong> do mercado educacional brasileiro.</p>

                            <p><strong>Art. 4º</strong> – <strong>As marcas ganhadoras</strong> do prêmio Top Educação – Educação Básica serão <strong>divulgadas em caderno especial</strong> na <strong>Plataforma Educação</strong>, edição de outubro, e <strong>premiadas em evento</strong> a ser realizado no mesmo mês.</p>
                        </div>
                    </div>
                </div>


                <div class="aba-item" id="inscricao">
                    <div class="aba-bloco">
                        <div class="icone">📝</div>
                        <div class="texto text-start">
                            <p><strong>Art. 1º</strong> – A <strong>marca é responsável por realizar sua inscrição</strong> e somente seus <strong>responsáveis/colaboradores</strong> poderão fazer a inscrição.</p>

                            <p><strong>Art. 2º</strong> – As inscrições vão até às <strong>23h59 do dia 29 de maio de 2025</strong>.</p>

                            <p><strong>Art. 3º</strong> – Após o término das inscrições, a <strong>votação para o Prêmio Top Educação terá início no dia 14 de junho de 2025</strong>, com término em <strong>20 de agosto de 2025</strong>.</p>

                            <p><strong>Art. 4º</strong> – A <strong>divulgação aos vencedores</strong> será feita diretamente pela <strong>RFM Editores</strong> até o dia <strong>30 de agosto de 2025</strong>.</p>

                            <p><strong>Art. 5º</strong> – A <strong>comunicação ao mercado</strong> acontece em <strong>outubro de 2025</strong> via site do prêmio e/ou cerimônia de premiação.</p>

                            <p><strong>Art. 6º</strong> – É expressamente <strong>proibido oferecer presentes ou prêmios aos votantes</strong>, sob pena de <strong>eliminação da marca</strong>.</p>

                            <p><strong>Art. 7º</strong> – É <strong>permitido divulgar a marca</strong> nos meios de comunicação, <strong>solicitando votos e indicando a categoria</strong>.</p>
                        </div>
                    </div>
                </div>


                <div class="aba-item" id="categorias">
                    <div class="aba-bloco">
                        <div class="icone">📚</div>
                        <div class="texto text-start">
                            <p><strong>As categorias da Educação Básica do Prêmio Top Educação 2025 são:</strong></p>

                            <ul>
                                <li>Acampamentos</li>
                                <li>Ação Social</li>
                                <li>Brinquedos Educativos</li>
                                <li>Consultoria Educacional</li>
                                <li>Editora de Livros Didáticos</li>
                                <li>Editora de Livros Didáticos de Idiomas</li>
                                <li>Educação Financeira</li>
                                <li>Educação Tecnológica</li>
                                <li>Fabricantes de Computadores / Tablets e Notebooks</li>
                                <li>Gestão Financeira</li>
                                <li>Instituição de Ensino para Formação de Docentes</li>
                                <li>Literatura Infantojuvenil</li>
                                <li>Programa Avançado de Inglês para Escolas</li>
                                <li>Programa de Educação Socioemocional</li>
                                <li>Projetos Educacionais</li>
                                <li>Facilities (cantinas escolares, segurança e terceirização)</li>
                                <li>Seguro Educacional</li>
                                <li>Sistema de Ensino Bilíngue</li>
                                <li>Sistema de Ensino para Rede Privada</li>
                                <li>Sistema de Ensino para Rede Pública</li>
                                <li>Softwares Administrativos/Gestão/Horários</li>
                                <li>Softwares Educacionais</li>
                                <li>Tecnologia de Audiovisual</li>
                                <li>Turismo Educacional</li>
                            </ul>
                        </div>
                    </div>
                </div>


                <div class="aba-item" id="apuracao">
                    <div class="aba-bloco">
                        <div class="icone">📊</div>
                        <div class="texto text-start">
                            <p><strong>Art. 1º</strong> – Os <strong>votos serão computados pela RFM Editores</strong> e <strong>divulgados ao público a partir de outubro de 2025</strong>.</p>

                            <p><strong>Art. 2º</strong> – Os <strong>resultados decorrentes da pesquisa</strong> da RFM Editores são <strong>inquestionáveis e irrecorríveis</strong>.</p>

                            <p><strong>Art. 3º</strong> – Se forem detectados <strong>casos extraordinários de fraude</strong> por parte de qualquer empresa participante, ela será <strong>desclassificada</strong>, <strong>não podendo recorrer</strong> da ação.</p>

                            <p><strong>Art. 4º</strong> – As <strong>empresas vencedoras</strong> do prêmio terão direito ao <strong>selo referente ao Prêmio Top Educação 2025</strong> e poderão utilizá-lo para fins de divulgação e publicidade. Porém, o <strong>logo não poderá, em nenhuma circunstância, ter seu conteúdo, cor ou formato alterados</strong>. Para utilização de qualquer outro logo, nome ou material de propriedade da RFM Editores, será necessária <strong>prévia autorização</strong>.</p>

                            <p><strong>Art. 5º</strong> – As <strong>marcas participantes do Top Educação de 2025</strong> serão automaticamente inscritas no <strong>Prêmio Top Educação de 2025</strong> nas mesmas categorias. Caso queiram <strong>mudar e/ou excluir alguma categoria</strong>, as marcas devem preencher normalmente o formulário de inscrição (<a href="#">clique aqui</a>). Qualquer dúvida ou problema, <strong>entrar em contato através do formulário</strong> (<a href="#">clique aqui</a>).</p>
                        </div>
                    </div>
                </div>


                <div class="aba-item" id="premiacao">
                    <div class="aba-bloco">
                        <div class="icone">🎉</div>
                        <div class="texto text-start">
                            <p><strong>Art. 1º</strong> – A <strong>cerimônia de premiação</strong> ocorrerá no mês de <strong>outubro de 2025</strong>, em <strong>local e data a serem definidos</strong>.</p>

                            <p><strong>Art. 2º</strong> – As <strong>três marcas mais indicadas em cada categoria</strong> serão divulgadas na <strong>edição de outubro da Revista Educação</strong>.</p>
                        </div>
                    </div>
                </div>


                <!-- Régua vertical -->
            <div class="regua-vertical">
                <div class="regua-marcador" id="reguaMarcador"></div>
            </div>
        </div>
    </div>
</section>
<script>
    document.addEventListener("DOMContentLoaded", function () {
        const buttons = document.querySelectorAll(".aba-btn");
        const tabs = document.querySelectorAll(".aba-item");
        const marcador = document.getElementById("reguaMarcador");

        buttons.forEach((btn, index) => {
            btn.addEventListener("click", function () {
                // Trocar botão ativo
                buttons.forEach(b => b.classList.remove("active"));
                this.classList.add("active");

                // Mostrar aba correta
                tabs.forEach(t => t.classList.remove("active"));
                const target = btn.dataset.tab;
                document.getElementById(target).classList.add("active");

                // Mover marcador da régua
                const total = buttons.length;
                const step = 100 / total;
                marcador.style.transform = `translateY(${index * step}%)`;
            });
        });
    });
</script>
