<?php
if (!session_id()) session_start();

if (!isset($_SESSION['user_id']) || !isset($_SESSION['user_name'])) {
    $_SESSION['msg'] = "<p align='center' style='color: #ff0000'>Necessário realizar o login para acessar a página!</p>";
    wp_safe_redirect(home_url('/login-index'));
    exit;
}

global $wpdb;
$user_id = $_SESSION['user_id'];

get_header();
include(TEMPLATEPATH . '/menu/nav-top.php');
?>

    <!-- Estilos personalizados CSS -->
 <link href="<?=bloginfo('template_url')?>/css/style-votacao.css?v=35" rel="stylesheet">

 <!-- Estilos personalizados JS -->
 <script src="<?php echo get_template_directory_uri();?>/inscricao/js/scripts-votacao.js"></script>

<div class="container">
    <div class="row mb-4">
        <div class="col-sm-6">
            <a href="<?php echo home_url(); ?>" class="logo"></a>
        </div>
        <div class="col-sm-6 d-flex justify-content-end">
            <div class="welcome-box">
                <br><br><br>
                <p class="welcome-text">Bem-vindo(a) <?php echo esc_html($_SESSION['user_name']); ?>!</p>
                <a class="btn-logout" href="<?php echo home_url('/logout'); ?>">Sair</a>
            </div>
        </div>
    </div>

    <h2 class="titulo-principal">Votação Prêmio Top Educação 2025</h2>
    <h4 class="text-center mb-4" style="font-weight: bold;">Educação Básica</h4>

    <div class="vote-wrapper">
        <div class="accordion accordion-flush" id="accordionFlushCatBasica">
            <?php
            $categorias = $wpdb->get_results("SELECT codigo, nome FROM wp_categorias WHERE LOWER(TRIM(tipo)) = LOWER(TRIM('Educação Básica'))");

            if (!empty($categorias)) :
                foreach ($categorias as $categoria) :
                    $cat_id = esc_attr($categoria->codigo);
                    $cat_nome = esc_html($categoria->nome);
                    ?>
                    <div class="accordion-item mb-3">
                        <h2 class="accordion-header" id="flush-heading-<?php echo $cat_id; ?>">
                            <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#flush-collapse-<?php echo $cat_id; ?>" aria-expanded="false" aria-controls="flush-collapse-<?php echo $cat_id; ?>">
                                <?php echo $cat_nome; ?>
                            </button>
                        </h2>
                        <div id="flush-collapse-<?php echo $cat_id; ?>" class="accordion-collapse collapse" aria-labelledby="flush-heading-<?php echo $cat_id; ?>" data-bs-parent="#accordionFlushCatBasica">
                            <div class="accordion-body">
                                <form class="vote-form">
                                    <input type="hidden" name="id_inscricao" value="<?php echo $user_id; ?>">
                                    <input type="hidden" name="id_categoria" value="<?php echo $cat_id; ?>">
                                    <input type="hidden" name="categoria" value="<?php echo $cat_nome; ?>">

                                    <?php
                                    $candidatos = $wpdb->get_results($wpdb->prepare("SELECT id, candidato FROM wp_candidatos WHERE id_categoria = %d", $cat_id));

                                    if (!empty($candidatos)) {
                                        foreach ($candidatos as $candidato) {
                                            echo "<div><input type='radio' name='candidato' value='" . esc_attr($candidato->id) . "' required> ";
                                            echo "<label>" . esc_html($candidato->candidato) . "</label></div>";
                                        }

                                        $ja_votou = $wpdb->get_var($wpdb->prepare("SELECT COUNT(*) FROM wp_votos WHERE id_inscricao = %d AND id_categoria = %d", $user_id, $cat_id));

                                        if ($ja_votou > 0) {
                                            echo '<div class="text-center mt-3"><span class="btn-votado">Categoria já votada</span></div>';
                                        } else {
                                            echo '<div class="text-center mt-3"><button class="btn-votar submit-vote" type="button">Votar</button></div>';
                                        }
                                    } else {
                                        echo "<p>Nenhum candidato disponível.</p>";
                                    }
                                    ?>

                                    <p class="feedback"></p>
                                </form>
                            </div>
                        </div>
                    </div>
                <?php
                endforeach;
            else :
                echo "<p class='text-center text-warning fw-bold'>Nenhuma categoria encontrada!</p>";
            endif;
            ?>
        </div>
    </div>
</div>

<?php get_footer(); ?>