<?php
/*
Template Name: Redefinir Senha
*/

get_header();
global $wpdb;

$token = sanitize_text_field($_GET['token'] ?? '');
$usuario = $wpdb->get_row("SELECT * FROM wp_inscricao WHERE recuperar_senha = '$token'");

echo "<script src='https://cdn.jsdelivr.net/npm/sweetalert2@11'></script>";

if (!$usuario) {
    echo "<script>
        Swal.fire({ icon: 'error', title: 'Token inválido ou expirado' });
    </script>";
    get_footer();
    exit;
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $nova_senha = $_POST['senha'];
    $senha_hash = password_hash($nova_senha, PASSWORD_DEFAULT);

    $wpdb->update('wp_inscricao', [
        'senha' => $senha_hash,
        'recuperar_senha' => null
    ], ['id' => $usuario->id]);

    echo "<script>
        Swal.fire({
            icon: 'success',
            title: 'Senha alterada com sucesso!',
        }).then(() => {
            window.location.href = '" . site_url('/login-index/') . "';
        });
    </script>";
    get_footer();
    exit;
}
?>

<!-- Estilos personalizados CSS -->
<link href="<?=bloginfo('template_url')?>/css/style-redefinir-senha.css?v=35" rel="stylesheet">

<div class="container">
    <div class="form-area">
        <h2 class="titulo-principal">Redefinir senha</h2>
        <form method="post">
            <input type="password" name="senha" class="input" placeholder="Nova senha" required>
            <input type="submit" value="Alterar senha" class="btn-enviar">
        </form>
    </div>
</div>

<?php get_footer(); ?>
