<?php
session_start();  // Inicia a sessão caso ainda não tenha sido iniciada

// Destrói TODAS as variáveis da sessão
$_SESSION = array();

// Remove o cookie de sessão (se existir)
if (ini_get("session.use_cookies")) {
    $params = session_get_cookie_params();
    setcookie(session_name(), '', time() - 42000,
        $params["path"], $params["domain"],
        $params["secure"], $params["httponly"]
    );
}

// Destroi a sessão
session_destroy();

// Redireciona o usuário para a página de login
header('Location: http://localhost/premiotopeducacao/login-index/');
exit; // Garante que o script para aqui
?>
