<?php
// Iniciar a sessão
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

global $wpdb;

// Redireciona se já estiver logado
if (isset($_SESSION['user_id']) && !empty($_SESSION['user_id'])) {
    wp_redirect(home_url('/votacao'));
    exit;
}

$erro = '';

// Validação de login
if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $email = sanitize_email($_POST['email']);
    $senha = $_POST['senha'];

    $usuario = $wpdb->get_row($wpdb->prepare("SELECT id, senha, nome FROM wp_inscricao WHERE email = %s", $email));

    if (!empty($usuario)) {
        if (password_verify($senha, $usuario->senha)) {
            $_SESSION['user_id'] = $usuario->id;
            $_SESSION['user_name'] = $usuario->nome;

            wp_redirect(home_url('/votacao'));
            exit;
        } else {
            $erro = "Senha incorreta.";
        }
    } else {
        $erro = "Usuário não encontrado.";
    }
}

get_header();
include(TEMPLATEPATH . '/menu/nav-top.php');
?>

<!-- Estilos personalizados CSS -->
<link href="<?=bloginfo('template_url')?>/css/style-login-index.css?v=35" rel="stylesheet">


<div class="login-wrapper">
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-md-8 col-lg-6">
                <div class="login-container">
                    <h2 class="login-title">Login</h2>

                    <?php if (!empty($erro)): ?>
                        <div class="alert alert-danger text-center"><?php echo esc_html($erro); ?></div>
                    <?php endif; ?>

                    <form method="POST" action="">
                        <div class="form-group">
                            <label>Email</label>
                            <input type="email" name="email" class="form-control" placeholder="Digite seu e-mail" required>
                        </div>

                        <div class="form-group">
                            <label>Senha</label>
                            <input type="password" name="senha" class="form-control" placeholder="Digite sua senha" required>
                        </div>

                        <button type="submit" class="btn-login">Entrar</button>
                    </form>

                    <br>
                    <p class="text-center">
                        <a href="<?php echo esc_url(home_url('/esqueci-senha')); ?>">Esqueci minha senha</a>
                    </p>
                </div>
            </div>
        </div>
    </div>
</div>

<?php get_footer(); ?>
