<?php get_header(); ?>

<?php include (TEMPLATEPATH . '/menu/nav-top.php'); ?>

<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <title>Inscrição - Prêmio Top Educação 2025</title>
    <meta name="viewport" content="width=device-width, initial-scale=1">

    <!-- Estilos personalizados CSS -->
    <link href="<?=bloginfo('template_url')?>/css/style-incricao-empresa.css?v=35" rel="stylesheet">

    <!-- Bootstrap -->
    <link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/bootstrap/4.3.1/css/bootstrap.min.css">

    <!-- jQuery + Inputmask -->
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.7.1/jquery.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery.inputmask/5.0.8/jquery.inputmask.min.js"></script>

    <!-- Estilos personalizados JS -->
    <script src="<?php echo get_template_directory_uri();?>/inscricao/js/desabilita-combo.js"></script>


    <!-- Scripts personalizados -->
    <script src="<?php echo get_template_directory_uri();?>/inscricao/js/desabilita-combo.js"></script>
    <script src="<?php echo get_template_directory_uri();?>/inscricao/js/valida-cnpj.js"></script>
    <script src="<?php echo get_template_directory_uri();?>/inscricao/js/formata-tel.js"></script>

</head>

<body>
<div class="form-wrapper">
    <div class="form-area">
        <p class="titulo-principal">Inscreva-se para a Votação do Prêmio Top Educação 2025</p>

        <form action="../confirma-inscricao-empresas" method="post">
            <p>Dados da Empresa</p>

            <input type="text" class="input" placeholder="Nome da Empresa" id="nome_empresa" name="nome_empresa">
            <input type="text" name="cnpj" id="cnpj" class="input" placeholder="CNPJ">
            <input type="text" class="input" placeholder="CEP" id="cep" name="cep">

            <input type="text" class="input" placeholder="Endereço" id="endereco" name="endereco">
            <input type="text" class="input" placeholder="Bairro" id="bairro" name="bairro">
            <input type="text" class="input" placeholder="Cidade" id="cidade" name="cidade">
            <input type="text" class="input" placeholder="Estado" id="estado" name="estado">


            <p>Representante da empresa</p>
            <input type="text" class="input" placeholder="Cargo" id="cargo" name="cargo">
            <input type="email" class="input" placeholder="E-mail" id="email" name="email">
            <input type="text" class="input" placeholder="Responsável/Contato" id="responsavel" name="responsavel">
            <input type="text" class="input" id="telefone" name="telefone" placeholder="Telefone">

            <p>1ª Categoria que deseja concorrer</p>
            <select name="select_1" id="select_1">
                <option value="" selected>Selecione uma categoria</option>
                <option disabled>----- EDUCAÇÃO BÁSICA -----</option>
                <?php
                global $wpdb;
                $categorias_basica = $wpdb->get_results("SELECT codigo, nome FROM wp_categorias WHERE tipo='EDUCAÇÃO BÁSICA'");
                foreach ($categorias_basica as $categoria) {
                    echo "<option value='{$categoria->codigo}'>{$categoria->nome}</option>";
                }
                ?>
                <option disabled>----- EDUCAÇÃO SUPERIOR -----</option>
                <?php
                $categorias_superior = $wpdb->get_results("SELECT codigo, nome FROM wp_categorias WHERE tipo='ENSINO SUPERIOR'");
                foreach ($categorias_superior as $categoria) {
                    echo "<option value='{$categoria->codigo}'>{$categoria->nome}</option>";
                }
                ?>
            </select>

            <p>2ª Categoria que deseja concorrer</p>
            <select name="select_2" id="select_2">
                <option value="" selected>Selecione uma categoria</option>
                <option disabled>----- EDUCAÇÃO BÁSICA -----</option>
                <?php
                foreach ($categorias_basica as $categoria) {
                    echo "<option value='{$categoria->codigo}'>{$categoria->nome}</option>";
                }
                ?>
                <option disabled>----- EDUCAÇÃO SUPERIOR -----</option>
                <?php
                foreach ($categorias_superior as $categoria) {
                    echo "<option value='{$categoria->codigo}'>{$categoria->nome}</option>";
                }
                ?>
            </select>

            <label class="texto-confirma">
                <input type="checkbox" id="confirma" name="confirma" value="1" checked>
                Concordo em receber comunicados das Plataformas Educação e Ensino Superior
            </label>

            <br><br>
            <input type="submit" value="INSCREVER" class="btn-enviar">
        </form>
    </div>
</div>

<?php get_footer(); ?>
</body>
</html>
