<?php
get_header();
global $wpdb;
?>

<!--Menu top-->
<?php include (TEMPLATEPATH . '/menu/nav-top.php'); ?>

<!-- Estilos personalizados CSS -->
<link href="<?=bloginfo('template_url')?>/css/style-confirma-inscricao.css?v=35" rel="stylesheet">



<body>
<?php
if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $nome = sanitize_text_field($_POST['nome']);
    $email = sanitize_email($_POST['email']);
    $cpf = sanitize_text_field($_POST['cpf']);
    $senha = password_hash($_POST['senha'], PASSWORD_DEFAULT);
    $data_votacao = current_time('mysql');
    $confirma = isset($_POST['confirma']) ? 1 : 0;

    echo "<script src='https://cdn.jsdelivr.net/npm/sweetalert2@11'></script>";

    // Verificar se o CPF já está cadastrado
    $verifica_cpf = $wpdb->get_row("SELECT nome FROM wp_inscricao WHERE cpf = '$cpf'");
    if ($verifica_cpf) {
        echo "<script>
            Swal.fire({
                icon: 'error',
                title: 'CPF já cadastrado',
                html: 'O CPF informado já foi utilizado por <strong>" . esc_html($verifica_cpf->nome) . "</strong>.'
            }).then(() => {
                history.back();
            });
        </script>";
        exit;
    }

    // Verificar se o e-mail já está cadastrado
    $verifica_email = $wpdb->get_row("SELECT nome FROM wp_inscricao WHERE email = '$email'");
    if ($verifica_email) {
        echo "<script>
            Swal.fire({
                icon: 'error',
                title: 'E-mail já cadastrado',
                html: 'O e-mail informado já foi utilizado por <strong>" . esc_html($verifica_email->nome) . "</strong>.'
            }).then(() => {
                history.back();
            });
        </script>";
        exit;
    }

    // INSERIR NO BANCO
    $insert = $wpdb->insert(
        'wp_inscricao',
        array(
            'nome' => $nome,
            'email' => $email,
            'cpf' => $cpf,
            'senha' => $senha,
            'data_votacao' => $data_votacao,
            'confirma' => $confirma,
        ),
        array('%s', '%s', '%s', '%s', '%s', '%d')
    );

    if ($insert) {
        echo '
        <div class="container">
            <p class="titulo-pag">Obrigado por se inscrever.</p>
            <a href="' . site_url('/login-index/') . '" class="btn-votar">VOTE AGORA</a>
        </div>';
    } else {
        echo "<script>
            Swal.fire({
                icon: 'error',
                title: 'Erro ao processar',
                text: 'Erro ao processar a inscrição. Tente novamente.'
            }).then(() => {
                history.back();
            });
        </script>";
    }
}
?>

</body>

<?php get_footer(); ?>
