<?php
get_header();
global $wpdb;
?>

<!--Menu top-->
<?php include (TEMPLATEPATH . '/menu/nav-top.php'); ?>

<!-- Estilos personalizados CSS -->
<link href="<?=bloginfo('template_url')?>/css/style-confirma-inscricao-empresas.css?v=35" rel="stylesheet">

<?php
// Lógica de envio
if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $required_fields = ['nome_empresa', 'email', 'cnpj', 'cargo', 'responsavel', 'telefone', 'estado', 'cidade', 'bairro', 'endereco', 'cep', 'select_1'];
    foreach ($required_fields as $field) {
        if (empty($_POST[$field])) {
            echo "<script src='https://cdn.jsdelivr.net/npm/sweetalert2@11'></script>";
            echo "<script>Swal.fire({icon: 'error', title: 'Campo obrigatório', text: 'O campo " . $field . " é obrigatório.'}).then(() => { history.back(); });</script>";
            exit;
        }
    }

    $nome_empresa = sanitize_text_field($_POST['nome_empresa']);
    $cnpj = sanitize_text_field($_POST['cnpj']);
    $estado = sanitize_text_field($_POST['estado']);
    $telefone = sanitize_text_field($_POST['telefone']);
    $endereco = sanitize_text_field($_POST['endereco']);
    $cidade = sanitize_text_field($_POST['cidade']);
    $bairro = sanitize_text_field($_POST['bairro']);
    $cep = sanitize_text_field($_POST['cep']);
    $cargo = sanitize_text_field($_POST['cargo']);
    $email = sanitize_email($_POST['email']);
    $responsavel = sanitize_text_field($_POST['responsavel']);
    $confirma = isset($_POST['confirma']) ? 1 : 0;
    $categoria1 = intval($_POST['select_1']);
    $categoria2 = !empty($_POST['select_2']) ? intval($_POST['select_2']) : NULL;
    $data_inscricao = current_time('mysql');

    echo "<script src='https://cdn.jsdelivr.net/npm/sweetalert2@11'></script>";

    // Verifica CNPJ
    $verifica_cnpj = $wpdb->get_row("SELECT nome_empresa FROM wp_inscricao_categorias WHERE cnpj = '$cnpj'");
    if ($verifica_cnpj) {
        echo "<script>
            Swal.fire({
                icon: 'error',
                title: 'CNPJ já cadastrado',
                html: 'O CNPJ informado já foi utilizado pela empresa <strong>" . esc_html($verifica_cnpj->nome_empresa) . "</strong>.'
            }).then(() => {
                history.back();
            });
        </script>";
        exit;
    }

    // Verifica e-mail
    $verifica_email = $wpdb->get_row("SELECT nome_empresa FROM wp_inscricao_categorias WHERE email = '$email'");
    if ($verifica_email) {
        echo "<script>
            Swal.fire({
                icon: 'error',
                title: 'E-mail já cadastrado',
                html: 'O e-mail informado já foi utilizado pela empresa <strong>" . esc_html($verifica_email->nome_empresa) . "</strong>.'
            }).then(() => {
                history.back();
            });
        </script>";
        exit;
    }

    // INSERÇÃO NORMAL
    $insert = $wpdb->insert(
        'wp_inscricao_categorias',
        array(
            'nome_empresa' => $nome_empresa,
            'email' => $email,
            'cnpj' => $cnpj,
            'cargo' => $cargo,
            'responsavel' => $responsavel,
            'telefone' => $telefone,
            'estado' => $estado,
            'cidade' => $cidade,
            'bairro' => $bairro,
            'endereco' => $endereco,
            'cep' => $cep,
            'data_inscricao' => $data_inscricao,
            'confirma' => $confirma,
            'categoria1' => $categoria1,
            'categoria2' => $categoria2,
        ),
        array('%s', '%s', '%s', '%s', '%s', '%s', '%s', '%s', '%s', '%s', '%s', '%s', '%d', '%d')
    );

    if ($insert) {
        $id_inscricao = $wpdb->insert_id;

        $wpdb->insert(
            'wp_candidatos',
            array(
                'id_categoria' => $categoria1,
                'candidato' => $nome_empresa,
            ),
            array('%d', '%s')
        );

        if (!empty($categoria2)) {
            $wpdb->insert(
                'wp_candidatos',
                array(
                    'id_categoria' => $categoria2,
                    'candidato' => $nome_empresa,
                ),
                array('%d', '%s')
            );
        }

        echo '
        <div class="container">
            <p class="titulo-pag">Obrigado por se inscrever.</p>
            <p class="subtitulo">Aguarde a votação em 10 de junho de 2025.</p>
            <a href="' . site_url() . '" class="btn-voltar">Voltar para o site</a>
        </div>';
    } else {
        echo "<script>Swal.fire({icon: 'error', title: 'Erro ao processar', text: 'Erro ao processar a inscrição. Tente novamente.'}).then(() => { history.back(); });</script>";
    }
}
?>

<?php get_footer(); ?>
