
<!-- MENU PRINCIPAL NAVBAR -->
<?php
/* Template Name: Página Contato */
get_header(); ?>

<nav class="navbar navbar-expand-lg navbar-light custom-navbar">
    <div class="container-fluid d-flex align-items-center justify-content-between">

        <!-- LOGO -->
        <a class="navbar-brand logo" href="#">
            <img src="<?php echo get_template_directory_uri(); ?>/img/logo_2025.png" alt="Logo">
        </a>

        <!-- BOTÃO HAMBURGUER (SÓ MOBILE) -->
        <button class="navbar-toggler d-lg-none" type="button"
                data-bs-toggle="offcanvas" data-bs-target="#menuMobileEstilo"
                aria-controls="menuMobileEstilo" aria-label="Toggle navigation">
            <span class="navbar-toggler-icon"></span>
        </button>

        <!-- MENU DESKTOP NORMAL -->
        <div class="collapse navbar-collapse justify-content-center" id="navbarNav">
            <?php
            if (has_nav_menu('menu-principal')) {
                wp_nav_menu(array(
                    'theme_location' => 'menu-principal',
                    'menu_class'     => 'navbar-nav',
                    'container'      => false,
                    'items_wrap'     => '<ul id="%1$s" class="%2$s">%3$s</ul>',
                    'fallback_cb'    => false,
                    'walker'         => class_exists('WP_Bootstrap_Navwalker') ? new WP_Bootstrap_Navwalker() : '',
                ));
            }
            ?>
        </div>
    </div>
</nav>

<!-- MENU LATERAL MOBILE (OFFCANVAS) -->
<div class="offcanvas offcanvas-start d-lg-none" tabindex="-1" id="menuMobileEstilo"
     aria-labelledby="menuMobileEstiloLabel" style="background-color: #c7044d; width: 280px;">

    <div class="offcanvas-header justify-content-end">
        <button type="button" class="btn" data-bs-dismiss="offcanvas" aria-label="Fechar">
            <i class="bi bi-arrow-left"></i>
        </button>
    </div>


    <div class="offcanvas-body">
        <!-- MENU WORDPRESS NO MOBILE -->
        <?php
        if (has_nav_menu('menu-principal')) {
            wp_nav_menu(array(
                'theme_location' => 'menu-principal',
                'menu_class'     => 'navbar-nav',
                'container'      => false,
                'items_wrap'     => '<ul id="%1$s" class="%2$s">%3$s</ul>',
                'fallback_cb'    => false,
                'walker'         => class_exists('WP_Bootstrap_Navwalker') ? new WP_Bootstrap_Navwalker() : '',
            ));
        }
        ?>
    </div>
</div>
