



(function($) {
    "use strict"; // Start of use strict

    // Smooth scrolling using jQuery easing
    $('a.js-scroll-trigger[href*="#"]:not([href="#"])').click(function() {
        if (location.pathname.replace(/^\//, '') == this.pathname.replace(/^\//, '') && location.hostname == this.hostname) {
            var target = $(this.hash);
            target = target.length ? target : $('[name=' + this.hash.slice(1) + ']');
            if (target.length) {
                $('html, body').animate({
                    scrollTop: (target.offset().top - 70)
                }, 1000, "easeInOutExpo");
                return false;
            }
        }
    });

})(jQuery); // End of use strict

/* assessibilidade */

//contraste
$("#AtribuiContraste").click(function () {
    $("html").toggleClass("atribuiContrasteBody");
});

//aumentar fonte
$("#AumentarFont").click(function () {
    $("body").toggleClass("zoomAumentarFontBody");
});

// sidebarMenu menu
$(document).ready(function () {
    $("#sidebarMenu").mCustomScrollbar({
        theme: "minimal"
    });

    $('#dismiss, .overlay').on('click', function () {
        $('#sidebarMenu').removeClass('active');
        $('.overlay').removeClass('active');
    });

    $('#sidebarCollapse').on('click', function () {
        $('#sidebarMenu').addClass('active');
        $('.overlay').addClass('active');
    });
});

//lazyloader
$("img.lazy").lazyload({
    effect : "fadeIn"
});
$("div.lazy").lazyload({
    effect : "fadeIn"
});

//wow animate
new WOW().init();

//EVENTO DESLIZANTE
window.onscroll = function () {
    eventoDeslizante()
};

function eventoDeslizante() {
    if(window.pageYOffset > 1000){
        $('#redes_sociais_noticia').addClass('sticky');
    }else{
        $('#redes_sociais_noticia').removeClass('sticky');
    }
}

//////// localstorage publicidade
/////// localstorage publicidade

function localStorageExpires()
{
    var toRemove = [],                      // Itens para serem removidos
        currentDate = new Date().getTime(); // Data atual em milissegundos

    for (var i = 0, j = localStorage.length; i < j; i++) {
        var key = localStorage.key(i),
            value = localStorage.getItem(key);

        // Verifica se o formato do item para evitar conflitar com outras aplicações
        if (value && value[0] === "{" && value.slice(-1) === "}") {

            // Decodifica de volta para JSON
            var current = JSON.parse(value);

            // Checa a chave expires do item especifico se for mais antigo que a data atual ele salva no array
            if (current.expires && current.expires <= currentDate) {
                toRemove.push(key);
            }
        }
    }

    // Remove itens que já passaram do tempo
    // Se remover no primeiro loop isto poderia afetar a ordem,
    // pois quando se remove um item geralmente o objeto ou array são reordenados
    for (var i = toRemove.length - 1; i >= 0; i--) {
        localStorage.removeItem(toRemove[i]);
    }
}

localStorageExpires();//Auto executa a limpeza

/**
 * Função para adicionar itens no localStorage
 * @param {string} chave Chave que será usada para obter o valor posteriormente
 * @param {*} valor Quase qualquer tipo de valor pode ser adicionado, desde que não falhe no JSON.stringify
 * @param {number} Tempo de vida em minutos do item
 */
function setLocalStorage(chave, valor, minutos)
{
    var expirarem = new Date().getTime() + (60000 * minutos);

    localStorage.setItem(chave, JSON.stringify({
        "value": valor,
        "expires": expirarem
    }));
}

/**
 * Função para obter itens do localStorage que ainda não expiraram
 * @param {string} chave Chave para obter o valor associado
 * @return {*} Retorna qualquer valor, se o item tiver expirado irá retorna undefined
 */
function getLocalStorage(chave)
{
    localStorageExpires();//Limpa itens

    var value = localStorage.getItem(chave);

    if (value && value[0] === "{" && value.slice(-1) === "}") {

        // Decodifica de volta para JSON
        var current = JSON.parse(value);

        return current.value;
    }
}

//fechar publicidade
$('#fecharPublicidadeHome').click(function() {
    setLocalStorage('publicidadeHome', 'inativo', 30);
    $("#publicidade_home").hide();
})

//verifica publicidade
var publicidade = getLocalStorage('publicidadeHome');
if(publicidade == 'inativo'){
    $("#publicidade_home").hide();
}

// funcao hover empresarios
$( ".conhecaBloco1" )
    .mouseover(function() {
        $(".descritivoConhecaBloco1").addClass('ativo');
    })
    .mouseout(function() {
        $(".descritivoConhecaBloco1").removeClass('ativo');
    });

$( ".conhecaBloco2" )
    .mouseover(function() {
        $(".descritivoConhecaBloco2").addClass('ativo');
    })
    .mouseout(function() {
        $(".descritivoConhecaBloco2").removeClass('ativo');
    });

$( ".conhecaBloco3" )
    .mouseover(function() {
        $(".descritivoConhecaBloco3").addClass('ativo');
    })
    .mouseout(function() {
        $(".descritivoConhecaBloco3").removeClass('ativo');
    });