
<!-- Máscaras + Busca CEP -->
    document.addEventListener("DOMContentLoaded", function () {
    // Máscaras
    $('#cnpj').inputmask('99.999.999/9999-99');
    $('#telefone').inputmask({
    mask: ['(99) 9999-9999', '(99) 99999-9999'],
    keepStatic: true
});
    $('#cep').inputmask('99999-999');

    // Auto-preencher com ViaCEP
    $('#cep').on('blur', function () {
    const cep = this.value.replace(/\D/g, '');
    if (cep.length === 8) {
    fetch(`https://viacep.com.br/ws/${cep}/json/`)
    .then(response => response.json())
    .then(data => {
    if (!data.erro) {
    $('#estado').val(data.uf);
    $('#cidade').val(data.localidade);
    $('#bairro').val(data.bairro);
    $('#endereco').val(data.logradouro);
} else {
    alert('CEP não encontrado.');
}
})
    .catch(() => alert('Erro ao buscar o CEP.'));
}
});

    // Validação
    document.querySelector("form").addEventListener("submit", function (e) {
    let valid = true;
    const campos = [
    'nome_empresa', 'cnpj', 'estado', 'cidade', 'endereco', 'bairro', 'cep',
    'cargo', 'email', 'responsavel', 'telefone'
    ];
    campos.forEach(id => {
    const el = document.getElementById(id);
    if (!el.value.trim()) {
    alert(`O campo ${el.placeholder || id} é obrigatório.`);
    el.focus();
    valid = false;
}
});

    if (!validarCNPJ(document.getElementById('cnpj').value)) {
    alert('CNPJ informado é inválido.');
    document.getElementById('cnpj').focus();
    valid = false;
}

    if (!valid) e.preventDefault();
});
});
