<?php
// Configurações do tema
function premio_tema_setup() {
    add_theme_support('title-tag');
    add_theme_support('post-thumbnails');

    register_nav_menus(array(
        'menu-principal' => __('Menu Principal', 'premiotopeducacao'),
    ));
}
add_action('after_setup_theme', 'premio_tema_setup');

// Enfileirar estilos e scripts
function premio_tema_enqueue_assets() {
    wp_enqueue_style('bootstrap-css', get_template_directory_uri() . '/vendor/bootstrap/css/bootstrap.css');
    wp_enqueue_script('bootstrap-js', get_template_directory_uri() . '/vendor/bootstrap/js/bootstrap.bundle.min.js', array('jquery'), null, true);
    wp_enqueue_style('style', get_stylesheet_uri());
}
add_action('wp_enqueue_scripts', 'premio_tema_enqueue_assets');

// Incluir WP_Bootstrap_Navwalker
require_once get_template_directory() . '/vendor/wp-bootstrap-navwalker-master/class-wp-bootstrap-navwalker.php';


function carregar_vencedores()
{
    $json_path = get_template_directory() . '/includes/vencedores.json'; // Caminho para o JSON
    if (file_exists($json_path)) {
        $json_data = file_get_contents($json_path);
        return json_decode($json_data, true); // Decodifica o JSON como array associativo
    }
    return []; // Retorna um array vazio caso o arquivo não exista
}

$vencedores = carregar_vencedores(); // Carrega os vencedores


function carregar_scripts() {
    wp_enqueue_script('modal-js', get_template_directory_uri() . '/js/modal.js', [], false, true);
}
add_action('wp_enqueue_scripts', 'carregar_scripts');


function iniciar_sessao() {
    if (!session_id()) {
        session_start();
    }
}


add_action('init', 'iniciar_sessao');
add_action('wp_ajax_processa_voto', 'processa_voto');
add_action('wp_ajax_nopriv_processa_voto', 'processa_voto');


function processa_voto() {
    global $wpdb;

    $user_id = intval($_POST['id_inscricao']);
    $id_categoria = intval($_POST['id_categoria']);
    $id_candidato = intval($_POST['candidato']);
    $categoria = sanitize_text_field($_POST['categoria']);

    if (!$user_id || !$id_categoria || !$id_candidato) {
        wp_send_json_error("Dados inválidos.");
    }

    $ja_votou = $wpdb->get_var($wpdb->prepare(
        "SELECT COUNT(*) FROM wp_votos WHERE id_inscricao = %d AND id_categoria = %d",
        $user_id, $id_categoria
    ));

    if ($ja_votou > 0) {
        wp_send_json_error("Você já votou nesta categoria!");
    }

    $wpdb->insert('wp_votos', [
        'id_inscricao' => $user_id,
        'id_categoria' => $id_categoria,
        'categoria' => $categoria,
        'id_candidato' => $id_candidato
    ]);

    wp_send_json_success("Voto registrado com sucesso!");
}



