<?php
/* Template Name: Galeria Custom */
get_header();
include (TEMPLATEPATH . '/menu/nav-top.php');
?>

<!-- Estilos personalizados CSS -->
<link href="<?=bloginfo('template_url')?>/css/style-page-galeria.css?v=35" rel="stylesheet">



<section class="galeria">
    <!-- Título da página -->
    <?php if (have_posts()) : while (have_posts()) : the_post(); ?>
        <h2 class="titulo-galeria"><?php the_title(); ?></h2>

        <!-- Botão de voltar -->
        <div class="voltar-wrap">
            <a href="<?php echo home_url(); ?>" class="botao-voltar">← Voltar para o início</a>
        </div>

        <!-- Galeria de imagens -->
        <div class="masonry-grid">
            <?php
            $content = apply_filters('the_content', get_the_content());
            $content = str_replace('<img', '<img loading="lazy"', $content); // Lazy load
            echo $content;
            ?>
        </div>
    <?php endwhile; else : ?>
        <h2 class="titulo-galeria">Galeria</h2>
        <p style="color: white; text-align: center;">Nenhuma imagem encontrada.</p>
    <?php endif; ?>
</section>

<?php get_footer(); ?>
